#include <stdio.h>
#include <assert.h>
#include <string.h>
#include <windows.h>
#include "resource.h"
  
double const PI = 3.14159265358979323846;

HINSTANCE dllInstance;

#define MAX_BUFFER_LENGTH		256			// in number of samples

class COOERecorder {
public:
	virtual bool Init();
	virtual bool IsMultiTrack();
	virtual bool IsTagged();
	virtual bool SaveAs(HWND parentwindow);
	virtual char *OutputFilename();
	virtual bool ReadyToRec();

	virtual bool TrackNames(int track_id, char *track_name);
	virtual bool SongTagData(int tag_index, char *tagdata);

    virtual bool Start(char * filename, int samplespersec);
    virtual bool WorkOutput(float *psamples, int numsamples);
	virtual bool WorkOutputMulti(int track_id, float *psamples, int numsamples);

    virtual bool Finish();
    virtual char *OutputSize();
    virtual void ConfigDlg(HWND parentwindow);
};

class rec : public COOERecorder {
public:
	virtual bool Init();
	virtual bool IsMultiTrack() { return false; };
	virtual bool IsTagged() { return true; };
	virtual bool SaveAs(HWND parentwindow);
	virtual char *OutputFilename();
	virtual bool ReadyToRec();

	virtual bool TrackNames(int track_id, char *track_name) { return false; };
	virtual bool SongTagData(int tag_index, char *tagdata);

    virtual bool Start(char * filename, int samplespersec);
    virtual bool WorkOutput(float *psamples, int numsamples);
	virtual bool WorkOutputMulti(int track_id, float *psamples, int numsamples) { return false; };

    virtual bool Finish();
    virtual char *OutputSize();
    virtual void ConfigDlg(HWND parentwindow);
public:
	char myfilename[255];
	FILE * myfilehandle;
	char songtitle[100];
	char songartist[100];
	int writtensofar;
	int bitdepth;
};

bool rec::Init(){
	sprintf(myfilename, "");
	myfilehandle = NULL;
	writtensofar = 0;
	bitdepth = 0;
	sprintf(songtitle, "");
	sprintf(songartist, "");
	return true;
}
bool rec::SaveAs(HWND parentwindow){
	OPENFILENAME ofl;
	char filename[255];
	int nSuccess;

	sprintf(filename,"untitled.au");
	ofl.lStructSize = sizeof(ofl);
	ofl.hwndOwner = parentwindow;
	ofl.hInstance = dllInstance;
	ofl.lpstrFilter = "Next\\Sun sound format (*.au)\0*.au\0";
	ofl.lpstrCustomFilter = NULL;
	ofl.nMaxCustFilter = NULL;
	ofl.nFilterIndex = 1;
	ofl.lpstrFile = filename;
	ofl.nMaxFile = 255;
	ofl.lpstrFileTitle = NULL;
	ofl.nMaxFileTitle = NULL;
	ofl.lpstrInitialDir = NULL;
	ofl.lpstrTitle = "Save Song Output as";
	ofl.Flags = OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST;
	ofl.nFileOffset = 0;
	ofl.nFileExtension = 0;
	ofl.lpstrDefExt = ".au";
	ofl.lCustData = NULL;
	ofl.lpfnHook = NULL;
	ofl.lpTemplateName = NULL;
	nSuccess = GetSaveFileName(&ofl);
	if (nSuccess == 0) {
		sprintf(myfilename, "");
	} else {
		sprintf(myfilename, ofl.lpstrFile);
	}
	return true;
}
char *rec::OutputFilename() {
	return myfilename;
}

bool rec::SongTagData(int tag_index, char *tagdata) {
	switch (tag_index) {
	case 0: sprintf(songtitle, tagdata); return true; 
	case 1: sprintf(songartist, tagdata); return true;
	case 2: return false;
	default:
		return false;
	}
}

bool rec::Start (char * filename, int samplespersec) {
	char addinfo[204];
	short data1 = 0x0000;
	char data1a = 0x00;
	char data1b = 0x00; // custom
	long data2 = 0xFFFFFFFF;
	long data3 = 0x03000000;
	long data4 = 0x44AC0000;
	long data5 = 0x02000000;
	long datablk=0x00000000;
	int i;

	myfilehandle = fopen(filename, "wb");
	writtensofar = 0;

	if (strlen(songartist) == 0) {
		if (strlen(songtitle) == 0) {
			sprintf(addinfo, "");
		} else {
			sprintf(addinfo, "%s", songtitle);
		}
	} else {
		if (strlen(songtitle) == 0) {
			sprintf(addinfo, "%s", songartist);
		} else {
			sprintf(addinfo, "%s - %s", songartist, songtitle);
		}
	}
	
	fwrite(".snd", 1, 4,myfilehandle);
	
	data1b = 24 + strlen(addinfo)+1;
	fwrite(&data1, sizeof(short), 1, myfilehandle);
	fwrite(&data1a, sizeof(char), 1, myfilehandle);
	fwrite(&data1b, sizeof(char), 1, myfilehandle);

	fwrite(&data2, sizeof(long), 1,myfilehandle);
	fwrite(&data3, sizeof(long), 1,myfilehandle);
	fwrite(&data4, sizeof(long), 1,myfilehandle);
	fwrite(&data5, sizeof(long), 1,myfilehandle);

	fwrite(addinfo, sizeof(char), strlen(addinfo)+1, myfilehandle);

	return true;
}
bool rec::ReadyToRec() {
	if (strcmp(myfilename, "") == 0) {
		return false;
	} else {
		return true;
	}

}

static union {
	short thepsamp;
	char  thepsampbytes[2];
};

bool rec::WorkOutput (float *psamples, int numsamples) {
	short psampsm[1024];
	char bufpsampbyte;
	for (int i = 0; i < (numsamples * 2); i++) {
		if (psamples[i] > 32767.0f) psamples[i] = 32767.0f;
		if (psamples[i] < -32766.0f) psamples[i] = -32766.0f;
		psampsm[i] = (short)psamples[i];
		thepsamp = psampsm[i];
		bufpsampbyte = thepsampbytes[0];
		thepsampbytes[0] = thepsampbytes[1];
		thepsampbytes[1] = bufpsampbyte;
		psampsm[i] = thepsamp;
	}
	writtensofar += numsamples;
	fwrite(psampsm, sizeof(short), numsamples * 2,myfilehandle);
	return true;
}

bool rec::Finish() {
	fflush(myfilehandle);
	fclose(myfilehandle);
	return true;
}

char * rec::OutputSize() {
	static char megs[32];
	if (bitdepth == 1) {
		sprintf(megs, "%.2fM", ((float)writtensofar * 4.0f / 1024.0f / 1024.0f));
	} else {
		sprintf(megs, "%.2fM", ((float)writtensofar * 2.0f * (float)sizeof(float) / 1024.0f / 1024.0f));
	}
	return megs;
}

rec *prec;

BOOL APIENTRY ConfigDialog (HWND hDlg, UINT uMsg, WPARAM wParam, LPARAM lParam) {
	switch(uMsg) {
	case WM_INITDIALOG:
	{
//		if (prec->bitdepth == 1) {
//			CheckDlgButton(hDlg,IDC_RADIO16,1);
//		} else {
//			CheckDlgButton(hDlg,IDC_RADIO32,1);
//		}
		return 1;
	}
	case WM_SHOWWINDOW:
	{
		return 1;
	}
	case WM_CLOSE:
	{
		EndDialog (hDlg, TRUE);
	}
	case WM_COMMAND:
		switch ( LOWORD (wParam))
		{
		case IDOK:
			
//			if (IsDlgButtonChecked(hDlg, IDC_RADIO32) == 1) { prec->bitdepth = 0; }
//			if (IsDlgButtonChecked(hDlg, IDC_RADIO16) == 1) { prec->bitdepth = 1; }

			EndDialog (hDlg, TRUE);
			break;
		case IDCANCEL:
			EndDialog (hDlg, TRUE);
			break;
		default:
			return 0;
		}
		break;
	}
	return 0;
}

void rec::ConfigDlg (HWND parentwindow) {
	prec = this;
	DialogBox(dllInstance, MAKEINTRESOURCE (IDD_CONFIG), parentwindow, (DLGPROC) &ConfigDialog);
}

extern "C" {
__declspec(dllexport) COOERecorder * __cdecl CreateRecorder() { return new rec; }
__declspec(dllexport) char * __cdecl RecInfo() { return "Raw Recorder by CyanPhase"; }
}

BOOL WINAPI DllMain ( HANDLE hModule, DWORD fwdreason, LPVOID lpReserved )
{
	switch (fwdreason) {
	case DLL_PROCESS_ATTACH: { dllInstance = (HINSTANCE) hModule; } break;
	case DLL_THREAD_ATTACH: break;
	case DLL_THREAD_DETACH: break;
	case DLL_PROCESS_DETACH: break;
	}
	return TRUE;
}
